/**   Start scripts by invoking Java class, e.g. 			
 **   java ScriptInterpreter "filename"   				
 **									
 **   The script gets called by a Java program and uses Java API and	
 **   BSF to build an AWT GUI frame in a scripting language		
 ************************************************************************/


/**     JavaScript Rhino imports Java packages     
/***************************************************/
importPackage(java.awt);
importPackage(java.lang);
importPackage(java.net);
importPackage(org.apache.bsf);

/**	Create GUI components     
/**********************************/
frame = new Frame("AWT Frame, implementiert in JavaScript");
panel = new Panel(new BorderLayout());
scroll = new Scrollbar(Scrollbar.HORIZONTAL);  

label = new Label("Servus");
button = new Button("JavaScript Button");
color = new Choice();
	color.add("green"); color.add("blue"); color.add("red"); 
text = new Choice();
	text.add("Hallo!"); text.add("Ciao."); text.add("Bis bald..."); 

panel.setBackground(Color.black);
label.setBackground(Color.lightGray);	
label.setAlignment(Label.CENTER);
	
/**	Pack the GUI	 
/*************************/
panel.add(BorderLayout.EAST, color);
panel.add(BorderLayout.WEST, text);
panel.add(BorderLayout.SOUTH, scroll);

frame.add(BorderLayout.NORTH, label);
frame.add(BorderLayout.CENTER, button);
frame.add(BorderLayout.SOUTH, panel);

/**	Add event handler to components	
/****************************************/
frame.addWindowListener( function(event, methodName) {
	if (methodName == "windowClosing") { System.exit(0);}
	if (methodName == "windowDeiconified") { label.setText("Willkommen zurck"); }
});

color.addItemListener( function(event, methodName) {
	if (methodName == "itemStateChanged") 
	{	
		switch (color.getSelectedIndex()) {
			case 0: label.setBackground(Color.green); break;
			case 1: label.setBackground(Color.blue); break;
			case 2: label.setBackground(Color.red); break;
			default: break;
		}		
		label.setFont(new Font("Dialog", Font.BOLD, 14));
	}
});

text.addItemListener( function(event) {
	label.setText(text.getSelectedItem());
});

button.addActionListener( function(event) {
	try {	
		btnLabel = bsf.lookupBean('btnLabel');
		java.lang.System.out.println(45);
		button.setLabel(btnLabel);
		} catch (e) {  }
});

/**	Display frame with properties	 
/*****************************************/
frame.resize(400, 400);
frame.setLocation(300, 300);
frame.pack();
frame.setVisible(true);

